/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSSoapHeaderFault;
import java.util.List;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;

public class WSSoapHeader {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSSoapHeader";
    protected WSDefinition m_definition = null;
    protected SOAPHeader m_soapHeader = null;
    protected WSSoapHeaderFault[] m_soapHeaderFaults = null;
    protected WSMessage m_soapHeaderMessage = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                this.m_definition = null;
                this.m_soapHeader = null;
                this.m_soapHeaderMessage = null;
                if (this.m_soapHeaderFaults != null) {
                    WSSoapHeaderFault soapHeaderFault = null;
                    for (int i = 0; i < this.m_soapHeaderFaults.length; ++i) {
                        if (this.m_soapHeaderFaults[i] == null) continue;
                        soapHeaderFault = this.m_soapHeaderFaults[i];
                        this.m_soapHeaderFaults[i] = null;
                        soapHeaderFault.releaseReferences();
                        soapHeaderFault = null;
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSSoapHeader(WSDefinition definition, SOAPHeader soapHeader) {
        this.m_definition = definition;
        this.m_soapHeader = soapHeader;
        this.initSoapHeaderFaults();
    }

    private void initSoapHeaderFaults() {
        List faults;
        if (this.m_soapHeader != null && (faults = this.m_soapHeader.getSOAPHeaderFaults()) != null) {
            this.m_soapHeaderFaults = new WSSoapHeaderFault[faults.size()];
            Object obj = null;
            for (int i = 0; i < faults.size(); ++i) {
                obj = faults.get(i);
                if (obj == null || !(obj instanceof SOAPHeaderFault)) continue;
                this.m_soapHeaderFaults[i] = new WSSoapHeaderFault(this.m_definition, obj);
            }
        }
    }

    public SOAPHeader getSoapHeader() {
        return this.m_soapHeader;
    }

    public String getNameSpace() {
        if (this.m_soapHeader != null) {
            return this.m_soapHeader.getNamespaceURI();
        }
        return null;
    }

    public String[] getMessageNamespaces() {
        this.getMessage();
        if (this.m_soapHeaderMessage != null) {
            return this.m_soapHeaderMessage.getNameSpaces();
        }
        return null;
    }

    public WSMessage getMessage() {
        QName msgName;
        if (this.m_soapHeaderMessage == null && this.m_soapHeader != null && (msgName = this.m_soapHeader.getMessage()) != null && this.m_definition != null) {
            this.m_soapHeaderMessage = this.m_definition.getMessage(msgName);
        }
        return this.m_soapHeaderMessage;
    }

    public String getPart() {
        if (this.m_soapHeader != null) {
            return this.m_soapHeader.getPart();
        }
        return null;
    }

    public String getUse() {
        if (this.m_soapHeader != null) {
            return this.m_soapHeader.getUse();
        }
        return null;
    }

    public String[] getEncodingStyles() {
        List list;
        String[] encodingStyles = null;
        if (encodingStyles == null && this.m_soapHeader != null && (list = this.m_soapHeader.getEncodingStyles()) != null && list.size() > 0) {
            encodingStyles = new String[list.size()];
            Object obj = null;
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj == null || !(obj instanceof String)) continue;
                encodingStyles[i] = obj;
            }
        }
        return encodingStyles;
    }

    public WSSoapHeaderFault[] getFaults() {
        return this.m_soapHeaderFaults;
    }

    public String toString() {
        if (this.m_soapHeader != null) {
            this.m_soapHeader.toString();
        }
        return null;
    }

    public String getTemplate() throws Exception {
        this.getMessage();
        if (this.m_soapHeaderMessage != null) {
            return this.m_soapHeaderMessage.getXMLMessageTemplate(null);
        }
        return new String();
    }

    String getXMLTemplate() throws Exception {
        this.getMessage();
        if (this.m_soapHeaderMessage != null) {
            return this.m_soapHeaderMessage.getXMLMessageTemplate(null);
        }
        return new String();
    }

    String getExpressionTemplate() throws Exception {
        this.getMessage();
        if (this.m_soapHeaderMessage != null) {
            return this.m_soapHeaderMessage.getExpressionMessageTemplate(null);
        }
        return new String();
    }
}

